/**
 * Item server plugin made by lorgan3. Big thanks to AJF for helping my with the 1001 issues I had while making this.
 * -do not steal
 * -do not hax
 * -hosted on ajfs server (http://l3.ajf.me/gg2/index.php)
*/

//Save the network buffer
global.ISPacketID = argument1;

//Token to tell the server which items you have
global.token = '';

//Make a map to save the items
global.itemMap = ds_map_create();

//Constraint for how often gifts can spawn
global.giftDelay = current_time;

//Unique key for gift related stuff
global.serverKey = '';

//Variables for debugging purposes
global.itemServerSprites = 0;
global.itemServerFrames = 0;
global.itemServerPixels = 0;
global.itemServerRequests = 0;

//make a directory to save the items.
global.itemDir = working_directory + "/ServerPluginsData";
if (!directory_exists(global.itemDir)) {
    directory_create(global.itemDir);
}
global.itemDir += "/itemserver/";
if (!directory_exists(global.itemDir)) {
    directory_create(global.itemDir);
}

//make the playerControl object create our downloadmanager
object_event_add(PlayerControl,ev_step, ev_step_begin,'if (!instance_exists(global.downloadManager)) instance_create(0,0,global.downloadManager);');

//add vars to the player
object_event_add(Player,ev_create,0,'
    hasHats = false;
    token = "";
');
object_event_add(Player,ev_step,ev_step_begin,'
    if (!variable_local_exists("hasHats")) {
        hasHats = false;
        token = false;
    }
');

//too lazy to set the notice type for noticeO, from now on it's custom by default
object_event_add(NoticeO,ev_create,0,'notice = NOTICE_CUSTOM');

//add a link to the ingame menu to view your backpack
object_event_add(InGameMenuController,ev_create,0,'
    itemServerLink = "http://l3.ajf.me/gg2/index.php";
    menu_addlink("Open itemserver", "execute_shell(itemServerLink,0);");
');

//initialize stuff
global.downloadManager = object_add();
object_set_persistent(global.downloadManager,true);
object_event_add(global.downloadManager,ev_create,0,'    
    ISStartTime = current_time;
    type = noone;
    
    socket = -1;
    response = "";
    
    host = "l3.ajf.me";
    path = "";
    
    CR = chr(13);
    LF = chr(10);
    CRLF = CR + LF;
    
    responseBody = buffer_create();
    tokenList = ds_list_create();   //High priority, needs to be downloaded first.
    playerList = ds_list_create();  //For remembering who sent the token
    itemList = ds_list_create();   //Medium priority.
    typeList = ds_list_create();    //Extra download request for things that dont require arguments. Download last.
    giftList = ds_list_create();    //List with weapon drop codes
    
    if (!global.isHost) {
        if (global.ISUsername != "") {
            if (global.logInViaBrowser) {
                execute_shell("http://l3.ajf.me/gg2/getToken.php?user_name="+string(global.ISUsername)+"&user_key="+string(global.ISKey),0);
                var token;
                token = get_string("Browser output","");
                if (string_length(token) != 15) {
                    show_message("Error invalid token, it has to be 15 characters in length");
                    exit;
                }
                //send the token straight to the server
                ISSendBuffer = buffer_create();
                write_ubyte(ISSendBuffer,15);
                write_string(ISSendBuffer,token);
                PluginPacketSend(global.ISPacketID,ISSendBuffer);
                buffer_destroy(ISSendBuffer);
            } else {
                //Get a token to send to the server if we can log in
                ds_list_add(typeList,0);
            }
        } else {
            //If we cant login, just tell the server to send us hats
            ISSendBuffer = buffer_create();
            write_ubyte(ISSendBuffer,0);
            PluginPacketSend(global.ISPacketID,ISSendBuffer);
            buffer_destroy(ISSendBuffer);
        }
    } else {
        ds_list_add(typeList,5);
        if (global.ISUsername == "" || global.ISKey == "") {
            //ask to login
            instance_create(0,0,global.loginManager);
        } else {
            ds_list_add(typeList,0);
        }
    }
    
');

//free used resources on destroy
object_event_add(global.downloadManager,ev_destroy,0,'
    buffer_destroy(responseBody);
    ds_list_destroy(tokenList);
    ds_list_destroy(playerList);
    ds_list_destroy(itemList);
    ds_list_destroy(typeList);
    ds_list_destroy(giftList);
    if (socket != -1) {
        socket_destroy_abortive(socket);
    }
');

//script that handles downloading
object_event_add(global.downloadManager,ev_step,ev_step_normal,'  
    if (socket != -1) {
        // Read the response
        var len;
        len = tcp_receive_available(socket);
        write_buffer_part(responseBody, socket, len);
        
        if(tcp_eof(socket)) {
            if(socket_has_error(socket)) {
                socket_destroy_abortive(socket);
                socket = -1;
                type = noone;
                buffer_clear(responseBody);
                exit;
            }
            
            //Done downloading, time to process it
            event_user(0);
            socket_destroy(socket);
            socket = -1;
            buffer_clear(responseBody);
        }
    } else {
        //nothing to do, check if theres something on the list.
        if (ds_list_size(tokenList) > 0) {
            type = 1;
            token = ds_list_find_value(tokenList,0);
            ds_list_delete(tokenList,0);
            lastPlayer = ds_list_find_value(playerList,0);
            ds_list_delete(playerList,0);
            path = "/gg2/getLoadout.php?token="+string(token)+"&server_key="+string(global.serverKey);
            event_user(1);
        } else if (ds_list_size(itemList) > 0) {
            type = 2;
            itemId = ds_list_find_value(itemList,0);
            ds_list_delete(itemList,0);
            path = string(itemId);
            event_user(1);
        } else if (ds_list_size(typeList) > 0) {
            type = ds_list_find_value(typeList,0);
            ds_list_delete(typeList,0);
            switch(type) {
                case 0:
                    path = "/gg2/getToken.php?user_name="+string(global.ISUsername)+"&user_key="+string(global.ISKey);
                break;
                case 3:
                    if (global.token != "") {
                        path = "/gg2/refreshToken.php?user_name="+string(global.ISUsername)+"&user_key="+string(global.ISKey)+"&token="+string(global.token);
                    }
                break;
                case 4:
                    if (!instance_exists(global.Gift)) {
                        break;
                    }
                    if (!instance_exists(global.Gift.player)) {
                        break;
                    }
                    path = "/gg2/giveGift.php?key="+string(ds_list_find_value(giftList,0))+"&token="+string(global.Gift.player.token)+"&server_key="+string(global.serverKey);
                    ds_list_delete(giftList,0);
                break;
                case 5:
                    path = "/gg2/serverStart.php";
                break;
            }
            event_user(1);
        }
    }
');

//handle server - client interaction and some other stuff
object_event_add(global.downloadManager,ev_step,ev_step_begin,'
    if (global.myself == -1 || !instance_exists(global.myself)) {
        instance_destroy();
        exit;
    }
    if (ISStartTime + 1000*60*60*2 < current_time) {
        //we played an hour, time to refresh our token.
        ISStartTime = current_time;
        with(global.downloadManager) {
            ds_list_add(typeList,3);
        }
    }
    if (!instance_exists(MenuController)) {
        if (keyboard_check_pressed(vk_f5)) instance_create(0,0,global.loginManager);
        else if (global.isHost && keyboard_check_pressed(vk_f4) && global.token != "") {
            //Allow the user to test his own sprites before having them added to the database
            var tmpSprite, tmpType;
            tmpType = median(0,get_integer("Select an item type (0-5)",0),5);
            tmpSprite = sprite_add(get_open_filename("gif file (.gif)|*.gif",""),1,1,0,0,0);
            sprite_set_offset(tmpSprite,sprite_get_width(tmpSprite)/2,sprite_get_height(tmpSprite)/2);
            with(global.myself.object) {
                switch(tmpType) {
                    case 0: 
                        hat = tmpSprite; 
                        sprite_index = global.ISSprite[player.class,player.team];
                        overlay = -1;
                    break;
                    case 1: projectileSkin = tmpSprite; break;
                    case 2: 
                        tauntOverlay = -1;
                        var originalLength;
                        originalLength = sprite_get_number(tauntsprite)/2;
                        tauntsprite = tmpSprite;
                        tauntlength = sprite_get_number(tauntsprite)/2;
                        tauntspeed = 3 * (tauntlength/originalLength);   //compensate for longer/shorter taunts
                        //Make sure that the offset is correct because i cant change this drawing code
                        sprite_set_offset(tmpSprite,global.classXOffset[player.class],global.classYOffset);
                    break;
                    case 3: bubbleOverlay = tmpSprite; break;
                    case 4: angel = tmpSprite; break;
                    case 5: 
                        deathSprite = tmpSprite; 
                        //Same here, set the offset correctly before using it.
                        sprite_set_offset(deathSprite,global.classXOffset[player.class],global.classYOffset);
                    break;
                }
            }
        }
    }
    
    if (global.isHost) {
        while(PluginPacketGetBuffer(global.ISPacketID) != -1) {
            ISReceiveBuffer = PluginPacketGetBuffer(global.ISPacketID);
            player = PluginPacketGetPlayer(global.ISPacketID);
            if (player == -1 || !instance_exists(player)) break;
            info = read_ubyte(ISReceiveBuffer);

            if (info == 0) {
                //the client isnt logged in, but has the plugin installed.
                player.hasHats = true;
                event_user(2);  //send all hat data
            } else {
                //the client is logged in and is sending his token.
                player.hasHats = true;
                event_user(2);  //send all hat data
                player.token = read_string(ISReceiveBuffer,15);
                //download the players loadout
                with(global.downloadManager) {
                    ds_list_add(tokenList,player.token);
                    ds_list_add(playerList,player);
                }
            }
            PluginPacketPop(global.ISPacketID);
        }
    } else {
        while(PluginPacketGetBuffer(global.ISPacketID) != -1) {
            ISReceiveBuffer = PluginPacketGetBuffer(global.ISPacketID);
            switch(read_ubyte(ISReceiveBuffer)) {
                case 0:
                    //A players loadout
                    player = ds_list_find_value(global.players, read_ubyte(ISReceiveBuffer));
                    player.hasHats = 2;
                    for(i=0;i<10;i+=1) {
                        for(j=0;j<3;j+=1) {
                            player.items[i,j*2] = read_ubyte(ISReceiveBuffer)-48;
                            player.items[i,j*2+1] = read_ushort(ISReceiveBuffer);
                        }
                    }
                    if (player.object != -1) {
                        with(player.object) event_user(11);
                    }
                break;
                case 1:
                    //A gift spawned!
                    gift = instance_create(read_ushort(ISReceiveBuffer)/5, read_ushort(ISReceiveBuffer)/5, global.Gift);
                    gift.image_index = read_ubyte(ISReceiveBuffer);
                    
                    with(NoticeO) instance_destroy();
                    notice = instance_create(0,0,NoticeO);
                    notice.message = "A gift has spawned!";
                break;
                case 2:
                    //gift owned
                    with(global.Gift) instance_destroy();
                    
                    with(NoticeO) instance_destroy();
                    notice = instance_create(0,0,NoticeO);
                    notice.message = string(ds_list_find_value(global.players,read_ubyte(ISReceiveBuffer)).name) + " has found the gift! It contained a " + string(read_string(ISReceiveBuffer,read_ubyte(ISReceiveBuffer)));
                break;
                case 3:
                    //due to some error the gift has to be removed
                    with(global.Gift) instance_destroy();
                break;
            }
            PluginPacketPop(global.ISPacketID);
        }
    }
');

//post download
object_event_add(global.downloadManager,ev_other,ev_user0,' 
    if (type == noone) {
        show_message("Error: downloaded something for no reason. ("+string(read_string(responseBody,buffer_size(responseBody)))+")"); 
    } else {
        switch(type) {
            case 0:
                response = read_string(responseBody,buffer_size(responseBody));
                if (string_length(response) != 15) {
                    //Reset the log in data
                    ini_open("gg2.ini");
                    ini_write_string("Itemserver","username","");
                    ini_write_string("Itemserver","userkey","");
                    ini_close();
                    
                    var msg;
                    msg = show_message_ext("Error: incorrect login","Ok","Retry","");
                    if (msg == 2) instance_create(0,0,global.loginManager);
                } else {
                    global.token = response;
                    if (global.isHost) {
                        //im host, no need to send the token, so parse it right away
                        global.myself.token = response;
                        ds_list_add(tokenList,response);
                        ds_list_add(playerList,global.myself);
                    } else {
                        //Received a token, better send it to the server
                        ISSendBuffer = buffer_create();
                        write_ubyte(ISSendBuffer,15);
                        write_string(ISSendBuffer,response);
                        PluginPacketSend(global.ISPacketID,ISSendBuffer);
                        buffer_destroy(ISSendBuffer);
                    }
                }
            break;
            case 1:
                if (global.isHost) {
                    if (buffer_size(responseBody) != 90) {
                        //The response should be 90 bytes
                        //cant really display an error as host so ignore the token.
                        type = noone;
                        exit;
                    } else {
                        with(lastPlayer) {
                            hasHats = 2;	//2 means: can see hats AND has hats himself (i chose a derpy variable name)
                            var i,j;
                            for(i=0;i<10;i+=1) {
                                for(j=0;j<3;j+=1) {
                                    items[i,j*2] = read_ubyte(other.responseBody)-48;
                                    items[i,j*2+1] = read_ushort(other.responseBody);
                                }
                            }
                        }
                        
                        if (lastPlayer.object != -1) {
                            with(lastPlayer.object) event_user(11);
                        }
                        
                        //send the whole loadout to all hat users (including the player id)  
                        ISSendBuffer = buffer_create();
                        write_ubyte(ISSendBuffer,0);
                        write_ubyte(ISSendBuffer,ds_list_find_index(global.players,lastPlayer));
                        write_buffer(ISSendBuffer,responseBody);   
                        for(i=1;i<ds_list_size(global.players);i+=1) {
                            _player = ds_list_find_value(global.players,i);
                            if (_player.hasHats < 1) continue;
                            PluginPacketSendTo(global.ISPacketID,ISSendBuffer,_player);
                        }
                        buffer_destroy(ISSendBuffer);  
                    }
                } else {
                    show_message("Whatever you did, this is not supposed to happen on a client. (Please post this error)");
                }
            break;
            case 2:
                write_buffer_to_file(responseBody,string(global.itemDir) + string(itemId) + ".gif");
                //This used to reload everyones items, but i removed this to reduce any possible lag.
            break;
            case 3:
                //we need to refresh our token every 2 hours so we can receive items. (we do it every hour to be safe)
                response = read_string(responseBody,buffer_size(responseBody));
                //let the host run even if refreshing fails.
                if (!global.isHost) {
                    if (string_length(response) != 2) {
                        show_message("Error: Failed to refresh token! Please rejoin the server.");
                    }
                }
            break;
            case 4:
                //The server gave an item to a player, lets see if it worked.
                if (global.isHost) {
                    if (buffer_size(responseBody) <= 16) {
                        //something went wrong
                        with(NoticeO) instance_destroy();
                        notice = instance_create(0,0,NoticeO);
                        notice.message = "Fatal error while giving gift.";
                        
                        //attempt to get a new server token because this old one is now broken
                        ds_list_add(typeList,5);
                    } else {
                        global.giftDelay = current_time + read_ubyte(responseBody)*1000*60;
                        ds_list_add(giftList,read_string(responseBody,15));
                        response = read_string(responseBody,buffer_size(responseBody)-16);
                        
                        ISSendBuffer = buffer_create();
                        if (string_length(response) == 0 || !instance_exists(global.Gift)) {
                            write_ubyte(ISSendBuffer,3);    //failed gift :c
                        } else if (instance_exists(global.Gift.player)){
                            write_ubyte(ISSendBuffer,2);    //succesful gift!
                            write_ubyte(ISSendBuffer,ds_list_find_index(global.players, global.Gift.player));
                            write_ubyte(ISSendBuffer,string_length(response));
                            write_string(ISSendBuffer,response);
                            
                            with(NoticeO) instance_destroy();
                            notice = instance_create(0,0,NoticeO);
                            notice.message = string(global.Gift.player.name) + " has found the gift! It contained a " + string(response);
                        }
    
                        for(i=1;i<ds_list_size(global.players);i+=1) {
                            player = ds_list_find_value(global.players,i);
                            if (!player.hasHats) continue;
                            PluginPacketSendTo(global.ISPacketID,ISSendBuffer,player);
                        }
                        buffer_destroy(ISSendBuffer);
                        
                        with(global.Gift) instance_destroy();  
                    }                 
                } else {
                    show_message("Whatever you did, this is not supposed to happen on a client. (Please post this error)");
                }
            break;
            case 5:
                if (buffer_size(responseBody) == 30) {
                    global.serverKey = read_string(responseBody,15);
                    ds_list_add(giftList,read_string(responseBody,15));
                    global.giftDelay = current_time+1000*60*15;
                } else {
                    with(NoticeO) instance_destroy();
                    notice = instance_create(0,0,NoticeO);
                    notice.message = "Could not connect to the itemserver (it may be down)";
                }
            break;
        }
    }
    type = noone;
');

//pre download
object_event_add(global.downloadManager,ev_other,ev_user1,'
    if (type == 2) {    //make sure we dont have the picture by now
        if (file_exists(global.itemDir+path+".gif")) {
            //we already have it so we are done
            type = noone;
            exit;
        } else {
            path = "/gg2/getItem.php?item_id="+path;
        }
    }
    global.itemServerRequests += 1;
    socket = tcp_connect(host, 80);
    response = "";
    
    write_string(socket, "GET http://" + host + path + CRLF + CRLF);
    socket_send(socket);
');

//Send all the loadout info to a player
object_event_add(global.downloadManager,ev_other,ev_user2,'
    ISSendBuffer = buffer_create();
    for(i=0;i<ds_list_size(global.players);i+=1) {
        _player = ds_list_find_value(global.players,i);
        if (_player == player) continue;
        if (_player.hasHats != 2) continue;
        
        write_ubyte(ISSendBuffer,0);    //sending loadout info
        write_ubyte(ISSendBuffer,i);
        for(i=0;i<10;i+=1) {
            for(j=0;j<3;j+=1) {
                write_ubyte(ISSendBuffer, _player.items[i,j*2]+48); //+48 because the itemserver sends the item type unencoded. oh well...
                write_ushort(ISSendBuffer, _player.items[i,j*2+1]);
            }
        }
        PluginPacketSendTo(global.ISPacketID,ISSendBuffer,player);
        buffer_clear(ISSendBuffer);
    }
    buffer_destroy(ISSendBuffer);
');

//Display debug information
object_event_add(global.downloadManager,ev_draw,0,'
    if (global.itemServerLogging) {
        var xOffset, yOffset, players;
        xOffset = view_xview[0] + 5;
        yOffset = view_yview[0] + 5;
        players = 0;
        draw_set_color(c_white);
        draw_set_alpha(1);
        draw_set_halign(fa_left);
        draw_text(xOffset,yOffset,"Item sprites: " + string(global.itemServerSprites));
        draw_text(xOffset,yOffset+20,"Item frames " + string(global.itemServerFrames));
        draw_text(xOffset,yOffset+40,"Item pixels: " + string(global.itemServerPixels));
        draw_text(xOffset,yOffset+60,"Item requests: " + string(global.itemServerRequests));
        with(Player) {
            if (hasHats == 2) players += 1;
        }
        draw_text(xOffset,yOffset+80,"Item owners: " + string(players));
    }
');

//Check what hats and stuff to add when creating the player
object_event_add(Character,ev_create,0,'event_user(11)');

//Reload the character items
//I hope this doesn't affect performance too much. It seems a bit complicated...
object_event_add(Character,ev_other,ev_user11,'
    projectileSkin = -1;
    flareSkin = -1;
    blastSkin = -1;
    hat = -1;
    bubbleOverlay = -1;
    angel = -1;
    angelX = 0;
    angelY = 0;
    angelOffset = 0;
    angelDir = 0.5;
    angelFrame = 0;
    deathSprite = -1;
        
    var haveItem, itemId, itemType;
    if (player.hasHats == 2) {
        for(i=0;i<3;i+=1) {
            haveItem = -2;
            itemId = player.items[player.class,i*2+1];
            itemType = player.items[player.class,i*2];
            if (itemId != 0 && itemType < 7) {
                if (ds_map_find_value(global.itemMap,itemId)) == 0 {
                    switch(itemType) {
                        case 6:
                            //Make sure we have all weapon sprites before adding them to the itemMap
                            var gotAll;
                            gotAll = 0;
                            if (!file_exists(global.itemDir + string(itemId) + "A.gif")) ds_list_add(global.downloadManager.itemList,string(itemId)+"A");
                            else gotAll += 1;
                            if (!file_exists(global.itemDir + string(itemId) + "B.gif")) ds_list_add(global.downloadManager.itemList,string(itemId)+"B");
                            else gotAll += 1;
                            
                            if (player.class == CLASS_SNIPER) {
                                gotAll -= 1;
                                if (!file_exists(global.itemDir + string(itemId) + "C.gif")) ds_list_add(global.downloadManager.itemList,string(itemId)+"C");
                                else gotAll += 1;
                            } else if (player.class = CLASS_PYRO) {
                                gotAll -= 2;
                                if (!file_exists(global.itemDir + string(itemId) + "C.gif")) ds_list_add(global.downloadManager.itemList,string(itemId)+"C");
                                else gotAll += 1;
                                if (!file_exists(global.itemDir + string(itemId) + "D.gif")) ds_list_add(global.downloadManager.itemList,string(itemId)+"D");
                                else gotAll += 1;
                            }
                            
                            if (gotAll >= 2) {
                                var list, tmp;
                                list = ds_list_create();
                                tmp = sprite_add(global.itemDir + string(itemId) + "A.gif",1,1,0,sprite_get_xoffset(currentWeapon.normalSprite),sprite_get_yoffset(currentWeapon.normalSprite));
                                ds_list_add(list,tmp);
                                tmp = sprite_add(global.itemDir + string(itemId) + "B.gif",1,1,0,sprite_get_xoffset(currentWeapon.recoilSprite),sprite_get_yoffset(currentWeapon.recoilSprite));
                                ds_list_add(list,tmp);
                                if (player.class == CLASS_SNIPER) {
                                    tmp = sprite_add(global.itemDir + string(itemId) + "C.gif",1,1,0,sprite_get_xoffset(currentWeapon.reloadSprite),sprite_get_yoffset(currentWeapon.reloadSprite));
                                    ds_list_add(list,tmp);
                                } else if (player.class == CLASS_PYRO) {
                                    tmp = sprite_add(global.itemDir + string(itemId) + "C.gif",1,1,0,sprite_get_xoffset(currentWeapon.blastSprite),sprite_get_yoffset(currentWeapon.blastSprite));
                                    ds_list_add(list,tmp);
                                    tmp = sprite_add(global.itemDir + string(itemId) + "D.gif",1,1,0,sprite_get_xoffset(currentWeapon.dropSprite),sprite_get_yoffset(currentWeapon.dropSprite));
                                    ds_list_add(list,tmp);
                                }
                                ds_map_add(global.itemMap,itemId,list);
                                haveItem = true;
                            }
                        break;
                        case 1:
                            if (player.class == CLASS_PYRO) {
                                //Make sure we have all weapon sprites before adding them to the itemMap
                                var gotAll;
                                gotAll = 0;
                                if (!file_exists(global.itemDir + string(itemId) + "A.gif")) ds_list_add(global.downloadManager.itemList,string(itemId)+"A");
                                else gotAll += 1;
                                if (!file_exists(global.itemDir + string(itemId) + "B.gif")) ds_list_add(global.downloadManager.itemList,string(itemId)+"B");
                                else gotAll += 1;
                                if (!file_exists(global.itemDir + string(itemId) + "C.gif")) ds_list_add(global.downloadManager.itemList,string(itemId)+"C");
                                else gotAll += 1;
                                
                                if (gotAll >= 3) {
                                    var list, tmp;
                                    list = ds_list_create();
                                    tmp = sprite_add(global.itemDir + string(itemId) + "A.gif",1,1,0,sprite_get_xoffset(FlameS),sprite_get_yoffset(FlameS));
                                    ds_list_add(list,tmp);
                                    tmp = sprite_add(global.itemDir + string(itemId) + "B.gif",1,1,0,sprite_get_xoffset(FlareS),sprite_get_yoffset(FlareS));
                                    ds_list_add(list,tmp);
                                    tmp = sprite_add(global.itemDir + string(itemId) + "C.gif",1,1,0,sprite_get_xoffset(AirBlastS),sprite_get_yoffset(AirBlastS));
                                    ds_list_add(list,tmp);
                                    ds_map_add(global.itemMap,itemId,list);
                                    haveItem = true;
                                }
                                break;
                            }
                        default:
                            if (!file_exists(global.itemDir + string(itemId) + ".gif")) ds_list_add(global.downloadManager.itemList,string(itemId));
                            else {
                                var tmp;
                                tmp = sprite_add(global.itemDir + string(itemId) + ".gif",1,1,0,0,0);
                                sprite_set_offset(tmp,sprite_get_width(tmp)/2,sprite_get_height(tmp)/2);
                                ds_map_add(global.itemMap,itemId,tmp);
                                haveItem = true;
                                
                                if (global.itemServerLogging) {
                                    global.itemServerSprites += 1;
                                    global.itemServerFrames += sprite_get_number(tmp);
                                    global.itemServerPixels += sprite_get_number(tmp) * sprite_get_width(tmp) * sprite_get_height(tmp);
                                }
                            }
                        break;
                    }
                } else haveItem = true;
                
                if (haveItem) {
                    switch(itemType) {
                        case 0: 
                            hat = ds_map_find_value(global.itemMap,itemId); 
                            sprite_index = global.ISSprite[player.class,player.team];
                            overlay = -1;   //remove the haxton sale mask.
                        break;
                        case 1: 
                            if (player.class == CLASS_PYRO) {
                                var list;
                                list = ds_map_find_value(global.itemMap,itemId);
                                projectileSkin = ds_list_find_value(list,0);
                                flareSkin = ds_list_find_value(list,1);
                                blastSkin = ds_list_find_value(list,2);
                            } else projectileSkin = ds_map_find_value(global.itemMap,itemId); 
                        break;
                        case 2: 
                            tauntOverlay = -1;
                            var originalLength;
                            originalLength = sprite_get_number(tauntsprite)/2;
                            tauntsprite = ds_map_find_value(global.itemMap,itemId);
                            tauntlength = sprite_get_number(tauntsprite)/2;
                            tauntspeed = 3 * (tauntlength/originalLength);   //compensate for longer/shorter taunts
                            //Make sure that the offset is correct because i cant change this drawing code
                            sprite_set_offset(tauntsprite,global.classXOffset[player.class],global.classYOffset);
                        break;
                        case 3: bubbleOverlay = ds_map_find_value(global.itemMap,itemId); break;
                        case 4: angel = ds_map_find_value(global.itemMap,itemId); break;
                        case 5: 
                            deathSprite = ds_map_find_value(global.itemMap,itemId); 
                            //Same here, set the offset correctly before using it.
                            sprite_set_offset(deathSprite,global.classXOffset[player.class],global.classYOffset);
                            break;
                        case 6:
                            var list;
                            list = ds_map_find_value(global.itemMap,itemId);
                            currentWeapon.normalSprite = ds_list_find_value(list,0);
                            currentWeapon.recoilSprite = ds_list_find_value(list,1);
                            if (player.class == CLASS_SNIPER) currentWeapon.reloadSprite = ds_list_find_value(list,2);
                            else if (player.class == CLASS_PYRO) {
                                currentWeapon.blastSprite = ds_list_find_value(list,2);
                                currentWeapon.dropSprite = ds_list_find_value(list,3);
                            }
                            currentWeapon.sprite_index = currentWeapon.normalSprite;
                        break;
                    }
                }
            }    
        }
    }
');

//Try spawning gifts
object_event_add(Character,ev_destroy,0,'
    if (!global.isHost) exit;
    if (instance_exists(global.Gift)) exit;
    if (!instance_exists(global.downloadManager)) exit;
    if (current_time < global.giftDelay) exit;
    if (ds_list_size(global.downloadManager.giftList) <= 0) exit;
    if (collision_point(player.object.x,player.object.y,SpawnRoom,0,0) >= 0) exit;
    if (ds_list_size(global.players) < 3) exit;
    if (lastDamageSource == GENERATOR_EXPLOSION || lastDamageSource == KILL_BOX || lastDamageSource == FRAG_BOX || lastDamageSource == -1) exit;

    if (random(14) < 1) {
        if (timeUnscathed < 10) {
            var gift;
            gift = instance_create(x,y,global.Gift);
            
            if (lastDamageSource != FINISHED_OFF && lastDamageSource != FINISHED_OFF_GIB) gift.image_index = (!player.team)+1;
        }
    }
');

//Import all graphic stuffs (derped when importing the sprites, so i add the slash here
execute_file(argument0+'/graphics.gml',argument0+'/');

//login data
//This is at the bottom so that everything is initialized before asking to login
ini_open('gg2.ini');
global.ISUsername = ini_read_string('Itemserver','username','');
global.ISKey = ini_read_string('Itemserver','userkey','');
global.itemServerLogging = ini_read_real('Itemserver','enable logging',0);
global.logInViaBrowser = ini_read_real('Itemserver','log in via browser',0);
ini_close();
