//offsets used to position the hats (and headless sprites)
global.classXOffset[CLASS_SCOUT] = sprite_get_xoffset(ScoutRedS);
global.classXOffset[CLASS_SOLDIER] = sprite_get_xoffset(SoldierRedS);
global.classXOffset[CLASS_SNIPER] = sprite_get_xoffset(SniperRedS);
global.classXOffset[CLASS_DEMOMAN] = sprite_get_xoffset(DemomanRedS);
global.classXOffset[CLASS_MEDIC] = sprite_get_xoffset(MedicRedS);
global.classXOffset[CLASS_ENGINEER] = sprite_get_xoffset(EngineerRedS);
global.classXOffset[CLASS_HEAVY] = sprite_get_xoffset(HeavyRedS);
global.classXOffset[CLASS_SPY] = sprite_get_xoffset(SpyRedS);
global.classXOffset[CLASS_PYRO] = sprite_get_xoffset(PyroRedS);
global.classXOffset[CLASS_QUOTE] = sprite_get_xoffset(QuoteRedS);
global.classYOffset = sprite_get_yoffset(ScoutRedS);

//set collision masks
object_set_mask(ScoutRed,ScoutRedS);
object_set_mask(SoldierRed,SoldierRedS);
object_set_mask(SniperRed,SniperRedS);
object_set_mask(DemomanRed,DemomanRedS);
object_set_mask(MedicRed,MedicRedS);
object_set_mask(EngineerRed,EngineerRedS);
object_set_mask(HeavyRed,HeavyRedS);
object_set_mask(SpyRed,SpyRedS);
object_set_mask(PyroRed,PyroRedS);
object_set_mask(QuoteRed,QuoteRedS)
object_set_mask(ScoutBlue,ScoutBlueS);
object_set_mask(SoldierBlue,SoldierBlueS);
object_set_mask(SniperBlue,SniperBlueS);
object_set_mask(DemomanBlue,DemomanBlueS);
object_set_mask(MedicBlue,MedicBlueS);
object_set_mask(EngineerBlue,EngineerBlueS);
object_set_mask(HeavyBlue,HeavyBlueS);
object_set_mask(SpyBlue,SpyBlueS);
object_set_mask(PyroBlue,PyroBlueS);
object_set_mask(QuoteBlue,CurlyBlueS);
object_set_mask(Rocket,RocketS);
object_set_mask(Shot,ShotS);
object_set_mask(BladeB,BladeProjectileS);
object_set_mask(BurningProjectile,FlameS);
object_set_mask(Mine,MineS);
object_set_mask(Needle,NeedleS);

//load a bunch of sprites
global.ISSprite[CLASS_SCOUT,TEAM_RED] = sprite_add(argument0+"ScoutRedS_strip6.png",6,1,0,global.classXOffset[CLASS_SCOUT],global.classYOffset);
global.ISSprite[CLASS_SCOUT,TEAM_BLUE] = sprite_add(argument0+"ScoutBlueS_strip6.png",6,1,0,global.classXOffset[CLASS_SCOUT],global.classYOffset);
global.ISSprite[CLASS_SOLDIER,TEAM_RED] = sprite_add(argument0+"SoldierRedS_strip6.png",6,1,0,global.classXOffset[CLASS_SOLDIER],global.classYOffset);
global.ISSprite[CLASS_SOLDIER,TEAM_BLUE] = sprite_add(argument0+"SoldierBlueS_strip6.png",6,1,0,global.classXOffset[CLASS_SOLDIER],global.classYOffset);
global.ISSprite[CLASS_SNIPER,TEAM_RED] = sprite_add(argument0+"SniperRedS_strip6.png",6,1,0,global.classXOffset[CLASS_SNIPER],global.classYOffset);
global.ISSprite[CLASS_SNIPER,TEAM_BLUE] = sprite_add(argument0+"SniperBlueS_strip6.png",6,1,0,global.classXOffset[CLASS_SNIPER],global.classYOffset);
global.ISSprite[CLASS_DEMOMAN,TEAM_RED] = sprite_add(argument0+"DemomanRedS_strip6.png",6,1,0,global.classXOffset[CLASS_DEMOMAN],global.classYOffset);
global.ISSprite[CLASS_DEMOMAN,TEAM_BLUE] = sprite_add(argument0+"DemomanBlueS_strip6.png",6,1,0,global.classXOffset[CLASS_DEMOMAN],global.classYOffset);
global.ISSprite[CLASS_MEDIC,TEAM_RED] = sprite_add(argument0+"MedicRedS_strip6.png",6,1,0,global.classXOffset[CLASS_MEDIC],global.classYOffset);
global.ISSprite[CLASS_MEDIC,TEAM_BLUE] = sprite_add(argument0+"MedicBlueS_strip6.png",6,1,0,global.classXOffset[CLASS_MEDIC],global.classYOffset);
global.ISSprite[CLASS_ENGINEER,TEAM_RED] = sprite_add(argument0+"EngineerRedS_strip6.png",6,1,0,global.classXOffset[CLASS_ENGINEER],global.classYOffset);
global.ISSprite[CLASS_ENGINEER,TEAM_BLUE] = sprite_add(argument0+"EngineerBlueS_strip6.png",6,1,0,global.classXOffset[CLASS_ENGINEER],global.classYOffset);
global.ISSprite[CLASS_HEAVY,TEAM_RED] = sprite_add(argument0+"HeavyRedS_strip6.png",6,1,0,global.classXOffset[CLASS_HEAVY],global.classYOffset);
global.ISSprite[CLASS_HEAVY,TEAM_BLUE] = sprite_add(argument0+"HeavyBlueS_strip6.png",6,1,0,global.classXOffset[CLASS_HEAVY],global.classYOffset);
global.ISSprite[CLASS_SPY,TEAM_RED] = sprite_add(argument0+"SpyRedS_strip6.png",6,1,0,global.classXOffset[CLASS_SPY],global.classYOffset);
global.ISSprite[CLASS_SPY,TEAM_BLUE] = sprite_add(argument0+"SpyBlueS_strip6.png",6,1,0,global.classXOffset[CLASS_SPY],global.classYOffset);
global.ISSprite[CLASS_PYRO,TEAM_RED] = sprite_add(argument0+"PyroRedS_strip6.png",6,1,0,global.classXOffset[CLASS_PYRO],global.classYOffset);
global.ISSprite[CLASS_PYRO,TEAM_BLUE] = sprite_add(argument0+"PyroBlueS_strip6.png",6,1,0,global.classXOffset[CLASS_PYRO],global.classYOffset);
global.ISSprite[CLASS_QUOTE,TEAM_RED] = sprite_add(argument0+"QuoteRedS_strip6.png",6,1,0,global.classXOffset[CLASS_QUOTE],global.classYOffset/2);
global.ISSprite[CLASS_QUOTE,TEAM_BLUE] = sprite_add(argument0+"CurlyBlueS_strip6.png",6,1,0,global.classXOffset[CLASS_QUOTE],global.classYOffset/2);

//obviously sniper has to be annoying
sprite_replace(SniperCrouchRedS,argument0+"SniperCrouchRedS_strip6.png",6,1,0,global.classXOffset[CLASS_SNIPER],global.classYOffset);
sprite_replace(SniperCrouchBlueS,argument0+"SniperCrouchBlueS_strip6.png",6,1,0,global.classXOffset[CLASS_SNIPER],global.classYOffset);
global.sniperHat = sprite_add(argument0+"SniperHead.png",4,1,0,global.classXOffset[CLASS_SNIPER],global.classYOffset);

//draw the hat & the angel
object_event_add(Character,ev_draw,0,'
    //gg2 is weird and sometimes forgets about this variabele
    if team == TEAM_RED ubercolour = c_red;
    else ubercolour = c_blue;
    
    //ignore invisible spies
    if (invisible) exit;
    
    if (player.hasHats == 2) {
        if (hat != -1) {
            var xr, yr;
            xr = round(x)-(global.classXOffset[player.class]-sprite_get_xoffset(hat))*image_xscale;
            yr = round(y)+sprite_get_yoffset(hat)-global.classYOffset;
            if (player.class == CLASS_QUOTE) yr += 20;
            if (zoomed) yr+=4;
            
            if (!omnomnomnom && !taunting && !player.humiliated ) {
                if (!ubered) draw_sprite_ext(hat,floor(player.class*4 + player.team*2 + animationImage),xr,yr,image_xscale,image_yscale,image_angle,c_white,image_alpha);
                else {
                    draw_sprite_ext(hat,floor(player.class*4 + player.team*2 + animationImage),xr,yr,image_xscale,image_yscale,image_angle,c_white,1);
                    draw_sprite_ext(hat,floor(player.class*4 + player.team*2 + animationImage),xr,yr,image_xscale,image_yscale,image_angle,ubercolour,0.7);
                }
            }
        } else if (zoomed) {
            if (!omnomnomnom && !taunting && !player.humiliated ) {
                var xr, yr;
                xr = round(x);
                yr = round(y)+4;
                if (!ubered) draw_sprite_ext(global.sniperHat,floor(player.team*2 + animationImage),xr,yr,image_xscale,image_yscale,image_angle,c_white,image_alpha);
                else {
                    draw_sprite_ext(global.sniperHat,floor(player.team*2 + animationImage),xr,yr,image_xscale,image_yscale,image_angle,c_white,1);
                    draw_sprite_ext(global.sniperHat,floor(player.team*2 + animationImage),xr,yr,image_xscale,image_yscale,image_angle,ubercolour,0.7);
                }
            }
        }
        if (angel != -1) {
            angelX = median(x-40,angelX,x+40);
            angelY = median(y-40,angelY,y);
            angelOffset += angelDir;
            if abs(angelOffset) > 15 angelDir *= -1;
            var dir;
            if angelX > x dir = -1;
            else dir = 1;
        
            if cloak {
                if angelFrame != 5 && global.particles == PARTICLES_NORMAL effect_create_above(ef_smoke,angelX,angelY,1,c_ltgray);
                angelFrame = 5;
            } else if !cloak && angelFrame == 5 {
                if global.particles == PARTICLES_NORMAL effect_create_above(ef_smoke,angelX,angelY,1,c_ltgray);
                angelFrame = 1;
            } else if abs(hspeed) > 6 angelFrame = 3;
            else if moveStatus == 1 angelFrame = 3;
            else if abs(hspeed) < 1 angelFrame = 0;
            else angelFrame = 1;
        
            if stabbing || ubered draw_sprite_ext(angel,angelFrame+floor(animationImage)+7*player.team,angelX,angelY+angelOffset,dir*1,1,0,c_white,1);
            else draw_sprite_ext(angel,angelFrame+floor(animationImage)+7*player.team,angelX,angelY+angelOffset,dir*1,1,0,c_white,image_alpha);
        }
    } else if (zoomed) {
        if (!omnomnomnom && !taunting && !player.humiliated ) {
            var xr, yr;
            xr = round(x);
            yr = round(y)+4;
            if (!ubered) draw_sprite_ext(global.sniperHat,floor(player.team*2 + animationImage),xr,yr,image_xscale,image_yscale,image_angle,c_white,image_alpha);
            else {
                draw_sprite_ext(global.sniperHat,floor(player.team*2 + animationImage),xr,yr,image_xscale,image_yscale,image_angle,c_white,1);
                draw_sprite_ext(global.sniperHat,floor(player.team*2 + animationImage),xr,yr,image_xscale,image_yscale,image_angle,ubercolour,0.7);
            }
        }
    }
');

//Modify the speechbubble to support animations :3
object_event_add(SpeechBubbleO,ev_create,0,'animIndex = 0');
object_event_add(SpeechBubbleO,ev_step,ev_step_normal,'
    if (owner.bubbleOverlay != -1 && image_index == 20) {
        animIndex += 0.25;
        if (round(animIndex) > sprite_get_number(owner.bubbleOverlay)/2) {
            animIndex = 0;
        }
    } else {
        animIndex = 0;
    }
');
object_event_add(SpeechBubbleO,ev_draw,0,'
    if (owner.bubbleOverlay != -1 && image_index == 20) {
        draw_sprite_ext(owner.bubbleOverlay,animIndex+sprite_get_number(owner.bubbleOverlay)/2*owner.player.team,x+11,y-8,image_xscale,image_yscale,image_angle,c_white,image_alpha);
    } else {
        draw_sprite_ext(sprite_index,image_index,x,y,image_xscale,image_yscale,image_angle,c_white,image_alpha);
    }
');

//different death sprite (animated even)
object_event_add(DeadGuy,ev_create,0,'
    team = 0;
    special = false;
');
object_event_add(DeadGuy,ev_step,ev_step_normal,'
    if (special) {
        if (round(image_index+0.25) < sprite_get_number(sprite_index)/2*(1+team)) image_index += 0.25;
    } 
');
object_event_add(Character,ev_destroy,0,'
    if (deathSprite != -1) {
        with(DeadGuy) {
            if (alarm[0] == 300 && point_distance(x,y,other.x,other.y) < 50) {
                if (sprite_get_number(other.deathSprite) <= 2) y+= 30;  //If its an animation, place the character on the ground
                team = other.player.team;
                special = true;
                sprite_index = other.deathSprite;
                image_index = team*sprite_get_number(sprite_index)/2;
            }
        }
    }
');

//projectile skins
object_event_add(Medigun,ev_other,ev_user2,'
    if (owner.projectileSkin == -1) exit;
    with(Needle) {
        if (ownerPlayer == other.ownerPlayer) sprite_index = other.owner.projectileSkin;
    }
');
object_event_add(Needle,ev_step,ev_step_begin,'
    image_speed = 0;
    image_index = ownerPlayer.team;
');
object_event_add(Rifle,ev_other,ev_user3,'
    if (owner.projectileSkin == -1) exit;
    if (justShot) {
        var obj;
        obj = instance_create(x2,y2,global.rifleParticle);
        obj.sprite_index = owner.projectileSkin;
        obj.image_index = sprite_get_number(owner.projectileSkin)/2*owner.team;
        obj.team = owner.team;
    }
');
object_event_add(Minegun,ev_other,ev_user3,'
    if (owner.projectileSkin == -1) exit;
    with(Mine) {
        if (ownerPlayer == other.ownerPlayer) sprite_index = other.owner.projectileSkin;
    }
');
object_event_add(Minigun,ev_other,ev_user1,'
    if (owner.projectileSkin == -1) exit;
    with(Shot) {
        if (ownerPlayer == other.ownerPlayer) sprite_index = other.owner.projectileSkin;
    }
');
object_event_add(Shot,ev_step,ev_step_begin,'
    image_speed = 0;
    image_index = ownerPlayer.team;
');
object_event_add(Flamethrower,ev_other,ev_user1,'
    if (owner.projectileSkin == -1) exit;
    with(Flame) {
        if (ownerPlayer == other.ownerPlayer && !variable_local_exists("hasTeam")) {
            sprite_index = other.owner.projectileSkin;
            image_index = sprite_get_number(sprite_index)/2*team;
            hasTeam = true;
        }
    }
');
object_event_add(Flamethrower,ev_other,ev_user2,'
    if (owner.projectileSkin == -1) exit;
    if (justBlast) {
        poof.sprite_index = owner.blastSkin;
        poof.team = ownerPlayer.team
        with(Flare) {
            if (ownerPlayer == other.ownerPlayer && !variable_local_exists("hasTeam")) {
                sprite_index = other.owner.flareSkin;
                image_index = sprite_get_number(sprite_index)/2*team;
                hasTeam = true;
            }
        }
    }
');
object_event_add(BurningProjectile,ev_step,ev_step_end,'
    if (!variable_local_exists("hasTeam")) exit;
    if (round(image_index) >= (sprite_get_number(sprite_index)/2)*(team+1) || round(image_index) < (sprite_get_number(sprite_index)/2)*(team)) image_index = sprite_get_number(sprite_index)/2*team;
');
object_event_add(AirBlastO,ev_create,0,'team = 0');
object_event_add(AirBlastO,ev_draw,0,'
    draw_sprite_ext(sprite_index,image_index+team*6,x,y,image_xscale,image_yscale,image_angle,c_white,image_alpha);
');
object_event_add(Scattergun,ev_other,ev_user3,'
    if (owner.projectileSkin == -1) exit;
    with(Shot) {
        if (ownerPlayer == other.ownerPlayer) sprite_index = other.owner.projectileSkin;
    }
');
object_event_add(Shotgun,ev_other,ev_user3,'
    if (owner.projectileSkin == -1) exit;
    with(Shot) {
        if (ownerPlayer == other.ownerPlayer) sprite_index = other.owner.projectileSkin;
    }
');
object_event_add(Rocketlauncher,ev_other,ev_user3,'
    if (owner.projectileSkin == -1) exit;
    with(Rocket) {
        if (ownerPlayer == other.ownerPlayer) sprite_index = other.owner.projectileSkin;
    }
');
object_event_add(Blade,ev_other,ev_user2,'
    if (owner.projectileSkin == -1) exit;
    with(BladeB) {
        if (ownerPlayer == other.ownerPlayer && !variable_local_exists("hasTeam")) {
            sprite_index = other.owner.projectileSkin;
            image_index = sprite_get_number(sprite_index)/2*team;
            hasTeam = true;
            image_speed = 0;
        }
    }
');
object_event_add(BladeB,ev_step,ev_step_normal,'
    if !(variable_local_exists("hasTeam")) exit;
    image_index += 1;
    if (image_index >= (sprite_get_number(sprite_index)/2)*(team+1)) image_index = sprite_get_number(sprite_index)/2*team;
');
object_event_add(Revolver,ev_other,ev_user3,'
    if (owner.projectileSkin == -1) exit;
    with(Shot) {
        if (ownerPlayer == other.ownerPlayer) sprite_index = other.owner.projectileSkin;
    }
');

//Make a particle just for sniper!
global.rifleParticle = object_add();
object_event_add(global.rifleParticle,ev_create,0,'
    team = 0;
    alarm[0] = 13;    
');
object_event_add(global.rifleParticle,ev_alarm,0,'instance_destroy()');
object_event_add(global.rifleParticle,ev_step,ev_step_end,'
    if (round(image_index) > (sprite_get_number(sprite_index)/2)*(team+1)) image_index = sprite_get_number(sprite_index)/2*team;   
');

//object that asks you to log in to the itemserver
global.loginManager = object_add();
object_set_parent(global.loginManager,InGameMenuController);
object_event_add(global.loginManager,ev_step,ev_step_normal,'//no');
object_event_add(global.loginManager,ev_draw,0,'//no');
object_event_add(global.loginManager,ev_keypress,vk_enter,'
    ini_open("gg2.ini");
    ini_write_string("Itemserver","username",global.ISUsername);
    ini_write_string("Itemserver","userkey",global.ISKey);
    if (global.ISUsername != "" && global.ISKey != "") {
        //some people just cant login through gg2. idk why
        if (global.logInViaBrowser) {
            execute_shell("http://l3.ajf.me/gg2/getToken.php?user_name="+string(global.ISUsername)+"&user_key="+string(global.ISKey),0);
            var token;
            token = get_string("Browser output","");
            if (string_length(token) != 15) {
                show_message("Error invalid token, it has to be 15 characters in length");
                exit;
            }
            //send the token straight to the server
            ISSendBuffer = buffer_create();
            write_ubyte(ISSendBuffer,15);
            write_string(ISSendBuffer,token);
            PluginPacketSend(global.ISPacketID,ISSendBuffer);
            buffer_destroy(ISSendBuffer);
        } else {
            //try logging in
            with(global.downloadManager) {
                ds_list_add(typeList,0);
            }
        }
    }
    ini_close();
    instance_destroy();
');
object_event_add(global.loginManager,ev_keypress,vk_escape,'instance_destroy()');
object_event_add(global.loginManager,ev_draw,0,'
    if (!variable_local_exists("select")) {
        select = 0;
        keyboard_string = global.ISUsername;
        pressedTab = false;
    }
    
    with(TeamSelectController) instance_destroy();
    with(ClassSelectController) instance_destroy();
    
    var xOffset, yOffset, xSize,ySize;
    xSize = view_wview[0];
    ySize = view_hview[0];
    xOffset = view_xview[0]+xSize/2-200;
    yOffset = view_yview[0]+ySize/2-70;
    
    draw_set_valign(fa_left);
    draw_set_halign(fa_top);
    draw_set_color(c_black);
    draw_set_alpha(0.8);
    draw_rectangle(xOffset,yOffset,xOffset+400,yOffset+140,false);
    draw_set_alpha(1);
    draw_rectangle(xOffset,yOffset,xOffset+400,yOffset+140,true);
    draw_set_color(c_white);
    draw_text(xOffset+5,yOffset+5,"Please log in to the GG2 itemserver!");
    draw_text(xOffset+5,yOffset+25,"User name:");
    draw_text(xOffset+5,yOffset+45,"User key:");
    draw_text(xOffset+5,yOffset+65,"Press enter to confirm.");
    draw_text(xOffset+5,yOffset+85,"Press escape to continue without logging in.");
    draw_text(xOffset+5,yOffset+105,"Click here to register (quick and easy!)");
    
    if (select == 0) {
        global.ISUsername = keyboard_string;
        draw_set_color(c_orange);
        draw_rectangle(xOffset+95,yOffset+23,xOffset+250,yOffset+41,true);
        draw_text(xOffset+100,yOffset+27,global.ISUsername);
        
        draw_set_color(c_white);
        draw_rectangle(xOffset+95,yOffset+43,xOffset+250,yOffset+61,true);
        draw_text(xOffset+100,yOffset+47,global.ISKey);
    } else if (select == 1) {
        global.ISKey = keyboard_string;
        draw_set_color(c_white);
        draw_rectangle(xOffset+95,yOffset+23,xOffset+250,yOffset+41,true);
        draw_text(xOffset+100,yOffset+27,global.ISUsername);
        
        draw_set_color(c_orange);
        draw_rectangle(xOffset+95,yOffset+43,xOffset+250,yOffset+61,true);
        draw_text(xOffset+100,yOffset+47,global.ISKey);
    } else {
        draw_rectangle(xOffset+95,yOffset+23,xOffset+250,yOffset+41,true);
        draw_text(xOffset+100,yOffset+27,global.ISUsername);
        draw_rectangle(xOffset+95,yOffset+43,xOffset+250,yOffset+61,true);
        draw_text(xOffset+100,yOffset+47,global.ISKey);
    }
    
    if (keyboard_check_direct(vk_tab) && !pressedTab) {
        select = !select;
        if (select == 0) keyboard_string = global.ISUsername;
        else keyboard_string = global.ISKey;
    }
    pressedTab = keyboard_check_direct(vk_tab);
    
    if (mouse_check_button_pressed(mb_right) || (keyboard_check(vk_control) && keyboard_check_pressed(ord("V")))) {
        keyboard_string = clipboard_get_text();
    }
    
    if (mouse_x > xOffset && mouse_x < xOffset+400) {
        if (mouse_y > yOffset+23 && mouse_y < yOffset+41) {
            if (mouse_check_button_pressed(mb_left)) {
                select = 0;
                keyboard_string = global.ISUsername;
            }
        } else if (mouse_y > yOffset+43 && mouse_y < yOffset+61) {
            if (mouse_check_button_pressed(mb_left)) {
                select = 1;
                keyboard_string = global.ISKey;
            }
        } else if (mouse_y > yOffset+103 && mouse_y < yOffset+123) {
            draw_set_color(c_orange);
            draw_text(xOffset+5,yOffset+105,"Click here to register (quick and easy!)");
            if (mouse_check_button_pressed(mb_left)) execute_shell("http://l3.ajf.me/gg2/register.php",0);
        }
    }
');

//Make a gift object for weapon drops
global.Gift = object_add();
global.GiftS = sprite_add(argument0+"Gifts.png",3,1,0,5,7);
object_event_add(global.Gift,ev_create,0,'
    player = noone;
    image_speed = 0;
    image_xscale = 2;
    image_yscale = 2;
    alarm[0] = 30*60*5;
    if (global.isHost) alarm[1] = 1;
    sprite_index = global.GiftS;
');
object_event_add(global.Gift,ev_alarm,0,'
    if (!global.isHost) exit;
    
    //Nobody seems to be able to pick it up, so just act as if the key failed
    ISSendBuffer = buffer_create();
    write_ubyte(ISSendBuffer,3);

    for(i=1;i<ds_list_size(global.players);i+=1) {
        _player = ds_list_find_value(global.players,i);
        if (_player.hasHats != 2) continue;
        PluginPacketSendTo(global.ISPacketID,ISSendBuffer,_player);
    }
    buffer_destroy(ISSendBuffer);
    instance_destroy();
');
object_event_add(global.Gift,ev_alarm,1,'
    //Tell everybody about this gift
    ISSendBuffer = buffer_create();
    write_ubyte(ISSendBuffer,1);
    write_ushort(ISSendBuffer,x*5);
    write_ushort(ISSendBuffer,y*5);
    write_ubyte(ISSendBuffer,image_index);
    
    with(NoticeO) instance_destroy();
    notice = instance_create(0,0,NoticeO);
    notice.message = "A gift has spawned!";
    
    for(i=1;i<ds_list_size(global.players);i+=1) {
        _player = ds_list_find_value(global.players,i);
        if (_player.hasHats != 2) continue;
        PluginPacketSendTo(global.ISPacketID,ISSendBuffer,_player);
    }
    buffer_destroy(ISSendBuffer);
'); 
object_event_add(global.Gift,ev_collision,Character,'
    if (!global.isHost) exit;
    if (player != noone) exit;
    if (other.player.token == "") exit;
    if (image_index != 0 && other.player.team+1 != image_index) exit; 
    alarm[0] = 30*60;   //Make sure the timer doesnt expire if someone just picked it up
    player = other.player;
    with(global.downloadManager) ds_list_add(typeList,4);
');