globalvar GNsoldierBomb;
GNsoldierBomb = object_add();
object_event_add(GNsoldierBomb, ev_create, 0, '
    speed = 8;
    alarm[0] = 120 / global.delta_factor;
    detonationTime = 15 / global.delta_factor;
    form = 0;
    width = 2;
    depth = -2;
    sprite_index = MineS;
    index = 0;
');

object_event_add(GNsoldierBomb, ev_alarm, 0, '
    if (form == 0) {
        instance_destroy();
    }
');

object_event_add(GNsoldierBomb, ev_alarm, 1, '
    form = 1;
    playsound(x, y, GNexplosionSnd);
    with(Character) {
        if (point_distance(x,0,other.x, 0) < 40 && player.team != other.ownerPlayer.team && ubered == 0) {
            damageCharacter(other.ownerPlayer, id, 70);
            if (lastDamageDealer != other.ownerPlayer and lastDamageDealer != player)
            {
                secondToLastDamageDealer = lastDamageDealer;
                alarm[4] = alarm[3]
            }
            alarm[3] = ASSIST_TIME;
            lastDamageDealer = other.ownerPlayer;
            lastDamageSource = GENERATOR_EXPLOSION;
            dealFlicker(id);
        }
    }
    with(Sentry) {
        if (point_distance(x,0,other.x, 0) < 40 && team != other.ownerPlayer.team) {
            damageSentry(other.ownerPlayer, id, 70);
            lastDamageDealer = other.ownerPlayer;
            lastDamageSource = FRAG_BOX;
        }
    }
    alarm[2] = 20 / global.delta_factor;
');

object_event_add(GNsoldierBomb, ev_alarm, 2, '
    instance_destroy();
');

object_event_add(GNsoldierBomb, ev_step, ev_step_begin, '
    if (form == 0) {
        image_angle += 5 * global.delta_factor;
        
        if (global.particles == PARTICLES_NORMAL && index > 1) {
            effect_create_above(ef_smokeup, x, y, 0, c_green);
            index = 0;
        }
        index += 0.3 * global.delta_factor;
        
        if(!variable_local_exists("firststep")) firststep = true;
        
        vspeed += 0.4 * global.delta_factor;
        image_angle = direction;
        
        if(!firststep && global.delta_factor != 1) {
            x += hspeed * global.delta_factor;
            y += vspeed * global.delta_factor;
            x -= hspeed;
            y -= vspeed;
        } else {
            firststep = false;
        }
        
        gunSetSolids();
        if (!place_free(x, y)) {
            speed = 0;
            form = 0.5;
            alarm[1] = detonationTime;
        }
        gunUnsetSolids();
    } else if (form >= 1) {
        if (width < 64 && index > 1) {
            width *= 2;
            index = 0
        }
        index += 0.5 * global.delta_factor;
    }
');
    
object_event_add(GNsoldierBomb, ev_draw, 0, '
    if (form < 1) {
        draw_sprite(sprite_index, ownerPlayer.team*2, x, y);
    } else {
        draw_sprite_ext(GNsoldierExplosionS, ownerPlayer.team, x, 0, width/16, room_height, 0, c_white, 1);
    }
');