globalvar GNsniperBomb;
GNsniperBomb = object_add();

object_event_add(GNsniperBomb, ev_create, 0, '
    speed = 2;
    built = 0;
    progress = 0;
    sprite_index = GNsniperBombS;

    wallSetSolid();
    // Try to get outside of the wallmask if were in it.
    if(!place_free(x, y))
        move_outside_solid(0, 6);
    if(!place_free(x, y))
        move_outside_solid(180, 12);
    if(!place_free(x, y))
    {
        move_outside_solid(0, 6);
        move_outside_solid(90, 100);
    }
    wallUnsetSolid();
');

object_event_add(GNsniperBomb, ev_alarm, 0, '
    instance_destroy();
    instance_create(x,y,Explosion);
    playsound(x, y, ExplosionSnd);
');

object_event_add(GNsniperBomb, ev_collision, Character, '
    if (other.team != ownerPlayer.team && built && other.ubered == 0) {
        other.vspeed = other.vspeed/2.5;
        other.hspeed = other.hspeed/5;
        other.hp -= 0.6 * global.delta_factor;
        damageCharacter(ownerPlayer, other.id, 1*global.delta_factor);
        if (other.lastDamageDealer != ownerPlayer and other.lastDamageDealer != other.player)
        {
            other.secondToLastDamageDealer = other.lastDamageDealer;
            other.alarm[4] = other.alarm[3]
        }
        other.alarm[3] = ASSIST_TIME;
        other.lastDamageDealer = ownerPlayer;
        other.lastDamageSource = 255;
    }
');

object_event_add(GNsniperBomb, ev_step, ev_step_begin, '
    wallSetSolid();
    
    if(place_free(x+hspeed, y+vspeed+0.6))
        vspeed += 0.6  * global.delta_factor;
    if(!place_free(x+hspeed, y+vspeed) and place_free(x, y))
        event_user(2);
    
    if(vspeed > 10)
        vspeed = 10;
    
    wallUnsetSolid();
    
    x += hspeed * global.delta_factor;
    y += vspeed * global.delta_factor;
    x -= hspeed;
    y -= vspeed;
    
    if (progress == 0) {
        if (vspeed == 0) {
            playsound(x,y,SentryFloorSnd);
            playsound(x,y,SentryBuildSnd);
            alarm[0] = 120 / global.delta_factor;
            progress += 0.25 * global.delta_factor;
            hspeed = 0;
        }
    } else {
        progress += 0.25 * global.delta_factor;
        if (progress >= 9) {
            built = 1;
            if (progress >= 14) {
                progress = 10;
            }
        }
    }
');

object_event_add(GNsniperBomb, ev_other, ev_user2, '
    wallSetSolid();
    really_move_contact_solid(direction, speed);
    if(!place_free(x, y+1))
        vspeed = 0;
    wallUnsetSolid();
');

object_event_add(GNsniperBomb, ev_draw, 0, '
    draw_sprite_ext(GNsniperBombS, floor(progress) + ownerPlayer.team*14, x, y, 1, 1, 0, c_white, 1);
');