/**
 * Garrison nauts plugin by Lorgan for haxxies 2014
 * Every class gets a unique supermove which can be activated using 'down' (S by default)
*/

global.GNPacketID = packetID;
global.GNspawn = false;

// read the ini (0=complete objective, 1=start objective, 2=always)
ini_open('gg2.ini');
global.GNmode = ini_read_real('server', 'garrison nauts mode', 1);
ini_write_real('server', 'garrison nauts mode', global.GNmode);
ini_close();

// Sprites
globalvar GNmarkerS, GNscoutTrailS, GNspySmokeS, GNsniperBombS, GNheavyShieldS, GNengiBullS, GNsoldierExplosionS, GNdemoPipeS, GNhudS;
GNmarkerS = sprite_add(directory + '/marker.png', 9, 0, 0, 24, -10);
GNscoutTrailS = sprite_add(directory + '/scoutTrail.png', 2, 0, 0, 1, 30);
GNspySmokeS = sprite_add(directory + '/spySmoke.png', 13, 0, 0, 30, 48);
GNsniperBombS = sprite_add(directory + '/sniperBomb.png', 28, 0, 0, 22, 30);
GNheavyShieldS = sprite_add(directory + '/heavyShield.png', 4, 0, 0, 16, 16);
//GNengiBullS = sprite_add(directory + '/engiBull.png', 4, 0, 0, 22, 22);
GNengiBullS = sprite_add(directory + '/engiBull.png', 16, 0, 0, 37, 20);
GNsoldierExplosionS = sprite_add(directory + '/soldierExplosion.png', 2, 0, 0, 8, 0);
GNdemoPipeS = sprite_add(directory + '/demoPipe.png', 2, 0, 0, 4, 2);
GNhudS = sprite_add(directory + '/GNhud.png', 2, 0, 0, 0, 0);

// Sounds
globalvar GNslideSnd, GNshieldSnd, GNexplosionSnd;
GNslideSnd = sound_add(directory + '/slide.wav', 0, 1);
GNshieldSnd = sound_add(directory + '/heavyShield.wav', 0, 1);
GNexplosionSnd = sound_add(directory + '/soldierBomb.wav', 0, 1);

// Extra objects
execute_file(directory + '/spyBomb.gml');
execute_file(directory + '/sniperBomb.gml');
execute_file(directory + '/engiBull.gml');
execute_file(directory + '/pyroBlaze.gml');
execute_file(directory + '/soldierBomb.gml');
execute_file(directory + '/demoPipe.gml');

// Initialize character vars
object_event_add(Character, ev_create, 0 ,'
    GNsuperUnlocked = 0;
    if (global.GNspawn || ((global.GNmode >= 2 || (global.GNmode == 0 && instance_exists(ArenaHUD)) || instance_exists(GeneratorHUD)) && global.isHost)) GNsuperUnlocked = 1;
    GNsuperStart = 0;
    GNsuper = 0;
    GNsuperEnd = 0;
    GNsuperCooldown = 0;
    GNsuperReload = 0;
    GNsuperMaxReload = 10;
    
    GNmoveDir = -1;
    GNmoveX = 0;
    GNmoveY = 0;
    GNtagQueue = ds_list_create();
    GNlastHP = 0;
    GNanimationIndex = 0;
    GNstun = 0;
    
    GNmarkerIndex = 0;
');

// Create the vars for host
with(Character) {
    GNsuperUnlocked = 0;
    if (global.GNspawn || ((global.GNmode >= 2 || (global.GNmode == 0 && instance_exists(ArenaHUD)) || instance_exists(GeneratorHUD)) && global.isHost)) GNsuperUnlocked = 1;
    GNsuperStart = 0;
    GNsuper = 0;
    GNsuperEnd = 0;
    GNsuperCooldown = 0;
    GNsuperReload = 0;
    GNsuperMaxReload = 10;
    
    GNmoveDir = -1;
    GNmoveX = 0;
    GNmoveY = 0;
    GNtagQueue = ds_list_create();
    GNlastHP = 0;
    GNanimationIndex = 0;
    GNstun = 0;
    
    GNmarkerIndex = 0;
}

// Extra triggers to enable the supers
object_event_add(Player, ev_create, 0, 'oldCaps = stats[CAPS];');
with(Player) oldCaps = stats[CAPS];

object_event_add(Player, ev_step, ev_step_normal, '
    if (stats[CAPS] > oldCaps) {
        if (object != -1 && instance_exists(object)) {
            object.GNsuperUnlocked = true;
        }
    }
    oldCaps = stats[CAPS];
');

// Sync players
object_event_add(Player, ev_step, ev_step_begin, '
    if (variable_local_exists("GNinit")) exit;
    GNinit = 1;
    
    if(global.isHost) {
        var buffer;
        buffer = buffer_create();
        for(i=0; i<ds_list_size(global.players); i+=1) {
            var _player;
            _player = ds_list_find_value(global.players, i);
            if (_player.object != -1 && instance_exists(_player.object)) {
                if (_player.object.GNsuperUnlocked || global.GNmode >= 2) {
                    write_ubyte(buffer, 0);
                    write_ubyte(buffer, i);
                }
            }
        }
        if (buffer_size(buffer) > 0) {
            PluginPacketSendTo(global.GNPacketID, buffer, id);
        }
        if (global.GNmode >= 2) {
            buffer_clear(buffer);
            write_ubyte(buffer, 2);
            PluginPacketSendTo(global.GNPacketID, buffer, id);
        }
        buffer_destroy(buffer);
    }
');

object_event_add(Player, ev_destroy, 0, '
    with(GNspyBomb) {
        if (ownerPlayer == other.id) instance_destroy();
    }
    with(GNdemoPipe) {
        if (ownerPlayer == other.id) instance_destroy();
    }
    with(GNengiBull) {
        if (ownerPlayer == other.id) instance_destroy();
    }
    with(GNsniperBomb) {
        if (ownerPlayer == other.id) instance_destroy();
    }
    with(GNsoldierBomb) {
        if (ownerPlayer == other.id) instance_destroy();
    }
');    

object_event_add(Character, ev_destroy, 0, '
    player.humiliated = false;
');

// Run this code before the collision code or stuff gets messed up
object_event_add(Character, ev_step, ev_step_begin, '   
    // Stun on characters
    if (GNstun > 0) {
        GNstun -= 1 * global.delta_factor;
        hspeed /= 2.5;
        vspeed /= 2.5;
    } else {
        GNstun = 0;
    }
    
    if (!GNsuperUnlocked) {
        if (global.isHost && global.GNmode == 1) {
            if (intel) {
                GNsuperUnlocked = true;
                    var buffer;
                    buffer = buffer_create();
                    write_ubyte(buffer, 0);
                    write_ubyte(buffer, ds_list_find_index(global.players, player));
                    PluginPacketSend(global.GNPacketID, buffer);
                    buffer_destroy(buffer);
            }
            if (cappingPoint != noone) {
                if (cappingPoint.capping != 0) {
                    GNsuperUnlocked = true;
                    var buffer;
                    buffer = buffer_create();
                    write_ubyte(buffer, 0);
                    write_ubyte(buffer, ds_list_find_index(global.players, player));
                    PluginPacketSend(global.GNPacketID, buffer);
                    buffer_destroy(buffer);
                }
            }
        }
        exit;
    }
     
    // Initialize the effect
    if (GNsuperStart) {
        GNsuperStart = 0;
        GNsuperCooldown = 10;
        GNsuperReload = 10;
        
        switch(player.class) {
            case CLASS_SCOUT:
                runPower = 0;
                GNmoveDir = aimDirection;
                GNmoveX = x;
                GNmoveY = y;
                GNsuperCooldown = 20;
                playsound(x,y,GNslideSnd);
                GNsuperReload = 5*30;
            break;
            case CLASS_SPY:
                var bomb;
                bomb = instance_create(x,y, GNspyBomb);
                bomb.ownerPlayer = player;
                bomb.direction = aimDirection;
                playsound(x,y,MinegunSnd);
                GNsuperCooldown = 0;        
                GNsuperReload = 3*30;       
            break;
            case CLASS_SNIPER:
                var bomb;
                bomb = instance_create(x,y, GNsniperBomb);
                bomb.ownerPlayer = player;
                bomb.direction = aimDirection;
                playsound(x,y,MinegunSnd);
                GNsuperCooldown = 0;
                GNsuperReload = 8*30;    
            break;
            case CLASS_HEAVY:
                GNlastHP = hp;
                playsound(x,y, GNshieldSnd);
                GNsuperCooldown = 120;
                GNsuperReload = 9*30;
            break;
            case CLASS_ENGINEER:
                var bull;
                bull = instance_create(x,y, GNengiBull);
                bull.ownerPlayer = player;
                bull.image_xscale = image_xscale;
                bull.direction = -image_xscale*90+90;
                playsound(x,y,SentryBuildSnd);
                GNsuperCooldown = 0; 
                GNsuperReload = 5*30;
            break;
            case CLASS_PYRO:
                runPower = 1.4;
                GNmoveX = 0;
                GNsuperCooldown = 120;
                playsound(x, y , BladeSnd);
                GNsuperReload = 9*30;
            break;
            case CLASS_QUOTE:
                runPower = 0;
                GNsuperCooldown = 120;
                playsound(x, y, SentryAlert);
                GNsuperReload = 5*30;
            break;
            case CLASS_SOLDIER:
                var bomb;
                bomb = instance_create(x, y, GNsoldierBomb);
                bomb.ownerPlayer = player;
                bomb.direction = aimDirection;
                playsound(x,y,MinegunSnd);
                GNsuperCooldown = 0;  
                GNsuperReload = 5*30;
            break;
            case CLASS_MEDIC:
                playsound(x, y, UberEndSnd);
                GNsuperCooldown = 120;
                GNsuperReload = 30*30;
            break;
            case CLASS_DEMOMAN:
                playsound(x, y, MinegunSnd);
                var bomb;
                bomb = instance_create(x,y, GNdemoPipe);
                bomb.ownerPlayer = player;
                bomb.direction = aimDirection-5;
                bomb.speed = 8;
                bomb.owner=id;
                bomb.team=player.team;
                
                bomb = instance_create(x,y, GNdemoPipe);
                bomb.ownerPlayer = player;
                bomb.direction = aimDirection+5;
                bomb.speed = 10;
                bomb.owner=id;
                bomb.team=player.team;
                GNsuperCooldown = 0;  
                GNsuperReload = 4*30; 
            break;
        }
        
        GNsuperMaxReload = GNsuperReload;
    }
    
    // While the effect is in progress
    if (GNsuper) {
        GNsuperCooldown -= 1*global.delta_factor;
        if (GNsuperCooldown <= 0) {
            GNsuper = 0;
            GNsuperEnd = 1;
        }

        switch(player.class) {
            case CLASS_SCOUT:
                hspeed = 15*((((GNmoveDir+270) mod 360)>180)*2-1);
                vspeed = lengthdir_y(20, GNmoveDir);
                moveStatus = 0;
            break;  
            case CLASS_HEAVY:
                if (GNlastHP > hp) {
                    hp += (GNlastHP-hp)/2;
                    GNanimationIndex = 1;
                }
                GNlastHP = hp;
            break;  
            case CLASS_PYRO:
                spinjumping = true;
                GNmoveX += 1 * global.delta_factor;
                if (GNmoveX >= 3) {
                    GNmoveX = 0;
                    shot = instance_create(x, y, GNpyroBlaze);
                    shot.speed = 0;
                    shot.owner = id;
                    shot.ownerPlayer = player;
                    shot.team = player.team;
                    shot.weapon = WEAPON_FLAMETHROWER;
                }
            break;   
            case CLASS_QUOTE:
                currentWeapon.readyToShoot = false;
                hspeed = lengthdir_x(8, aimDirection);
                vspeed = lengthdir_y(8, aimDirection);
                if (hp <= 5) {
                    GNsuperCooldown = 0;
                    playsound(x, y, ExplosionSnd);
                } else {
                    hp -= 0.3 * global.delta_factor;
                    with(Character) {
                        if (player.team != other.player.team && ubered == 0) {
                            if (point_distance(x, y, other.x, other.y) < 64) {
                                damageCharacter(other.player, id, 2*global.delta_factor);
                                if (lastDamageDealer != other.player and lastDamageDealer != player)
                                {
                                    secondToLastDamageDealer = lastDamageDealer;
                                    alarm[4] = alarm[3]
                                }
                                alarm[3] = ASSIST_TIME;
                                lastDamageDealer = other.player;
                                lastDamageSource = WEAPON_REFLECTED_STICKY;
                                dealFlicker(id);
                                other.hp += 2 * global.delta_factor;
                            }
                        }
                    }
                    with(Sentry) {
                        if (team != other.player.team) {
                            if (point_distance(x, y, other.x, other.y) < 64) {
                                damageSentry(other.player, id, 2*global.delta_factor);
                                lastDamageDealer = other.player;
                                lastDamageSource = WEAPON_REFLECTED_STICKY;
                            }
                        }
                    }
                }
            break;   
            case CLASS_MEDIC:
                if (currentWeapon.uberCharge <= 0) {
                    GNsuperCooldown = 0;
                    with(NoticeO) instance_destroy();
                    instance_create(0,0,NoticeO);
                    NoticeO.notice = NOTICE_CUSTOM;
                    NoticeO.message = "You require at least some uber to use this super.";
                    break;
                }
                currentWeapon.uberCharge -= 2.2 * global.delta_factor;
                var totalStolen, allies;
                totalStolen = 0;
                allies = ds_list_create();
                with(Character) {
                    if ((ubered == 0 || player.team == other.player.team) && point_distance(x, y, other.x, other.y) < 300 && !place_meeting(x,y,SpawnRoom) && collision_line(x, y, other.x, other.y, Obstacle, true, true) <= -1 && !cloak) {        
                        if (player.team != other.player.team) {
                            totalStolen += 0.3*global.delta_factor;
                            damageCharacter(other.player, id, 0.5*global.delta_factor);
                            if (lastDamageDealer != other.player and lastDamageDealer != player)
                            {
                                secondToLastDamageDealer = lastDamageDealer;
                                alarm[4] = alarm[3]
                            }
                            alarm[3] = ASSIST_TIME;
                            lastDamageDealer = other.player;
                            lastDamageSource = 255;
                        } else if (hp < maxHp) {
                            ds_list_add(allies, id);
                        }
                    }
                }
                // Add some bonus hp
                totalStolen += 0.25*ds_list_size(allies)*global.delta_factor;
                
                for(i=0; i<ds_list_size(allies); i+=1) {
                    _char = ds_list_find_value(allies, i);
                    if (_char.player.team == player.team) {
                        _char.hp += totalStolen/ds_list_size(allies);
                        if (currentWeapon.ubering) {
                            _char.ubered = 1;
                            _char.alarm[2] = 3 / global.delta_factor; 
                        }
                    }
                }
                ds_list_destroy(allies);
            break;  
        }
    } else if (GNsuperReload > 0) {
        GNsuperReload -= 1*global.delta_factor;
    }
    
    // Terminate the effect
    if (GNsuperEnd) {
        GNsuperEnd = 0;
        switch(player.class) {
            case CLASS_SCOUT:
                runPower = 1.4;
                doublejumpUsed = 1;
                ds_list_clear(GNtagQueue);
            break;
            case CLASS_PYRO:
                runPower = 1.1;
                spinjumping = false;
            break;
            case CLASS_QUOTE:
                currentWeapon.readyToShoot = true;
                runPower = 1.07;
            break;
        }
    }
'); 

// Free resources
object_event_add(Character, ev_destroy, 0, '
    ds_list_destroy(GNtagQueue);
');

// Draw effects
object_event_add(Character, ev_draw, 0, '
    xoffset = view_xview[0];
    yoffset = view_yview[0];
    xsize = view_wview[0];
    ysize = view_hview[0];

    if (distance_to_point(xoffset+xsize/2,yoffset+ysize/2) > 800) exit;
    if (invisible) exit;

    if (GNsuperUnlocked) {
        var color;
        if (player.team == TEAM_RED) color = c_orange;
        else color = c_aqua;
        
        if (player.class == CLASS_QUOTE) {
            draw_sprite_ext(GNmarkerS, floor(GNmarkerIndex), x, y-12, 1, 1, 0, color, image_alpha-0.3);
        } else {
            draw_sprite_ext(GNmarkerS, floor(GNmarkerIndex), x, y, 1, 1, 0, color, image_alpha-0.3);
        }
        
        GNmarkerIndex += 0.25*global.delta_factor;
        if (GNmarkerIndex >= 9) GNmarkerIndex -= 9;
    }
    
    if (GNsuper) {
        switch(player.class) {
            case CLASS_SCOUT:
                var i, GNx, GNy;
                i = 0;
                GNx = GNmoveX;
                GNy = GNmoveY;
                for (i=0; i<10; i+=1) {
                    draw_sprite_ext(GNscoutTrailS, player.team, GNx, GNy, 15, 1, 0, c_white, 0.4);
                    GNx += 20*((((GNmoveDir+270) mod 360)>180)*2-1);
                    GNy += lengthdir_y(20, GNmoveDir);
                }            
            break;
            case CLASS_HEAVY: 
                draw_sprite_ext(GNheavyShieldS, ceil(GNanimationIndex) + player.team*2, x, y, 1.5, 1.5, 0, c_white, 0.6);
                GNanimationIndex = max(0, GNanimationIndex-0.3*global.delta_factor);
            break;
            case CLASS_QUOTE:
                draw_sprite_ext(GNheavyShieldS, floor(GNanimationIndex) + player.team*2, x, y, 2, 2, 0, c_white, 0.6);
                GNanimationIndex += 0.3*global.delta_factor;
                if (GNanimationIndex >= 2) {
                    GNanimationIndex -= 2;
                }
            break;
            case CLASS_MEDIC:
                var color, xdrawpos, ydrawpos;
                if(player.team == TEAM_RED) color = c_red;
                else color = c_blue;
                xdrawpos = round(currentWeapon.x+currentWeapon.xoffset*image_xscale);
                ydrawpos = round(currentWeapon.y+currentWeapon.yoffset);
                draw_set_alpha(0.3);
                
                with(Character) {
                    if ((ubered == 0 || player.team == other.player.team && player != other.currentWeapon.healTarget && id != other.id) && point_distance(x, y, other.x, other.y) < 300 && !place_meeting(x,y,SpawnRoom) && collision_line(x, y, other.x, other.y, Obstacle, true, true) <= -1 && !cloak) {        
                        draw_line_width_color(xdrawpos+lengthdir_x(20,other.aimDirection),ydrawpos+lengthdir_y(20,other.aimDirection), x, y, 5, color, color);
                    }
                }
            break;
        }
    }
');

object_event_add(Character, ev_collision, Character, '
    if (player.class == CLASS_SCOUT && GNsuper) {
        if (other.player.team != player.team && ds_list_find_index(GNtagQueue, other.id) == -1 && other.ubered == 0) {
            ds_list_add(GNtagQueue, other.id);
            damageCharacter(player, other.id, 50);
            if (other.lastDamageDealer != player and other.lastDamageDealer != other.player)
            {
                other.secondToLastDamageDealer = other.lastDamageDealer;
                other.alarm[4] = other.alarm[3]
            }
            other.alarm[3] = ASSIST_TIME;
            other.lastDamageDealer = player;
            other.lastDamageSource = WEAPON_REFLECTED_ROCKET;
            
            var blood;
            if(global.gibLevel > 0)
            {
                blood = instance_create(x,y,Blood);
                blood.direction = direction-180;
            }
            dealFlicker(other.id);
            with(other)
            {
                motion_add(other.direction, other.speed*0.3);
            }
        }
    }
');

globalvar GNcontroller;
GNcontroller = object_add();
object_set_persistent(GNcontroller, true);
object_set_visible(GNcontroller, false);
object_event_add(PlayerControl, ev_step, ev_step_begin, '
    if (!instance_exists(GNcontroller)) instance_create(0, 0, GNcontroller);
');

object_event_add(GNcontroller, ev_step, ev_step_begin, '
    if (keyboard_check_pressed(global.down) && global.myself.team != -1 && global.myself.object != -1 && global.myself.humiliated == 0) {
        if (!global.myself.object.cloak) {
            var buffer;
            buffer = buffer_create();
            write_ubyte(buffer, 1);
            
            if (global.isHost) {
                PluginPacketSendTo(global.GNPacketID, buffer, global.myself);
            } else {
                PluginPacketSend(global.GNPacketID, buffer);
            }
        }
    }

    if (global.isHost) {
        while(PluginPacketGetBuffer(global.GNPacketID) != -1) {
            receiveBuffer = PluginPacketGetBuffer(global.GNPacketID);
            player = PluginPacketGetPlayer(global.GNPacketID);
            if (player == -1 || !instance_exists(player)) break;
            
            if (player.object != -1 && instance_exists(player.object) && !player.humiliated) {
                if (player.object.GNsuperUnlocked && player.object.GNsuperCooldown <= 0 && player.object.GNsuperReload <= 0 && !player.object.cloak) {
                    player.object.GNsuperStart = 1;
                    player.object.GNsuper = 1;
                
                    var buffer;
                    buffer = buffer_create();
                    write_ubyte(buffer, 1);
                    write_ubyte(buffer, ds_list_find_index(global.players, player));
                    PluginPacketSend(global.GNPacketID, buffer);
                }
            }
            PluginPacketPop(global.GNPacketID);
        }
    } else {
        while(PluginPacketGetBuffer(global.GNPacketID) != -1) {
            receiveBuffer = PluginPacketGetBuffer(global.GNPacketID);
            switch(read_ubyte(receiveBuffer)) {
                case 0:
                    // a player that gained super powers
                    player = ds_list_find_value(global.players, read_ubyte(receiveBuffer));
                    if (player.object != -1 && instance_exists(player.object)) {
                        player.object.GNsuperUnlocked = 1;
                    }
                break;
                case 1:
                    // a player activates his super move
                    player = ds_list_find_value(global.players, read_ubyte(receiveBuffer));
                    if (player.object != -1 && instance_exists(player.object)) {
                        player.object.GNsuperUnlocked = 1;
                        player.object.GNsuperStart = 1;
                        player.object.GNsuper = 1;
                    }
                break;
                case 2:
                    // The server is on garrison nauts mode 2 so spawn with super
                    global.GNspawn = true;
                break;
            }
            PluginPacketPop(global.GNPacketID);
        }
    }
');

// draw the superhud
object_event_add(HealthHud, ev_draw, 0, '
    xsize = view_wview[0];
    ysize = view_hview[0];
    
    if(global.myself.object == -1) {
        instance_destroy();
        exit; 
    }
    if (global.myself.team == TEAM_RED) draw_set_color(make_color_rgb(165, 70, 64));
    else draw_set_color(make_color_rgb(73, 93, 104));
    draw_rectangle(view_xview[0]+91, view_yview[0]+ysize-51, view_xview[0]+121, view_yview[0]+ysize-16, false);
    
    if (global.myself.object.GNsuperReload > 0) {
        draw_set_color(c_black);
        draw_set_alpha(0.5);
        draw_rectangle(view_xview[0]+91, view_yview[0]+ysize-51+35 * (1-(global.myself.object.GNsuperReload/global.myself.object.GNsuperMaxReload)), view_xview[0]+121, view_yview[0]+ysize-16, false);
    }
    draw_sprite_ext(GNhudS, global.myself.object.GNsuperUnlocked, view_xview[0]+87, view_yview[0]+ysize-55, 2, 2, 0, c_white, 1);
');