globalvar GNengiBull;
GNengiBull = object_add();

object_event_add(GNengiBull, ev_create, 0, '
    speed = 7;
    image_speed = 0;
    sprite_index = GNengiBullS;
    alarm[0] = 70 / global.delta_factor;

    wallSetSolid();
    
    // Try to get outside of the wallmask if were in it.
    if(!place_free(x, y))
        move_outside_solid(0, 6);
    if(!place_free(x, y))
        move_outside_solid(180, 12);
    if(!place_free(x, y))
    {
        move_outside_solid(0, 6);
        move_outside_solid(90, 100);
    }
    wallUnsetSolid();
');

object_event_add(GNengiBull, ev_alarm, 0, '
    instance_destroy();
    instance_create(x,y,Explosion);
    playsound(x, y, ExplosionSnd);
');

object_event_add(GNengiBull, ev_collision, Character, '
    if (other.team != ownerPlayer.team) {
        with(other) {
            motion_add(other.direction, other.speed*1.3);
        }
        
        if (other.lastDamageDealer != ownerPlayer and other.lastDamageDealer != other.player)
        {
            other.secondToLastDamageDealer = other.lastDamageDealer;
            other.alarm[4] = other.alarm[3]
        }
        other.alarm[3] = ASSIST_TIME;
        other.lastDamageDealer = ownerPlayer;
        other.lastDamageSource = KILL_BOX;
    }
');

object_event_add(GNengiBull, ev_step, ev_step_begin, '
    wallSetSolid();    
    if(!place_free(x+hspeed, y+vspeed) and place_free(x, y)) event_user(2);
    wallUnsetSolid();
    x += hspeed * global.delta_factor;
    x -= hspeed;
');

object_event_add(GNengiBull, ev_other, ev_user2, '
    wallSetSolid();
    really_move_contact_solid(direction, speed);
    speed = 0;
    wallUnsetSolid();
');

object_event_add(GNengiBull, ev_draw, 0, '
    draw_sprite_ext(GNengiBullS, floor(image_index) + ownerPlayer.team*8, x, y, image_xscale, 1, 0, c_white, 1);
    image_index += 0.4 * global.delta_factor;
    if (image_index >= 8) {
        image_index = 0;
    }
');