globalvar GNdemoPipe;
GNdemoPipe = object_add();
object_event_add(GNdemoPipe, ev_create, 0, '
    speed = 8;
    alarm[0] = 40 / global.delta_factor;
    
    explosionDamage = 30;
    blastRadius = 40;
    affectRadius = 65;
    knockBack = 10;
    splashThreshhold = true;
    knockback = true;
    
    sprite_index = MineS;
    index = 0;
');

object_event_add(GNdemoPipe, ev_alarm, 0, '
    event_user(2);
');

object_event_add(GNdemoPipe, ev_other, ev_user2, '
    instance_create(x,y,Explosion);
    playsound(x,y,ExplosionSnd);
    
    with (Character) {
        if (distance_to_object(other) < other.blastRadius and !(team == other.team and id != other.ownerPlayer.object and place_meeting(x, y+1, Obstacle)))
        {
            var rdir, vectorfactor;
            rdir = point_direction(other.x ,other.y, (bbox_left+bbox_right)/2, (bbox_top+bbox_bottom)/2);
            vectorfactor = point_distance(0, 0, sin(degtorad(rdir)), cos(degtorad(rdir))*0.8);
            if (1 - distance_to_object(other)/other.blastRadius <= 0.25 and other.splashThreshhold)
                continue;
            motion_add(rdir, min(15, other.knockback-other.knockback*(distance_to_object(other)/other.blastRadius)) * vectorfactor);
            if((other.team != team or id==other.ownerPlayer.object) and !ubered and hp > 0)
            {
                var dmg;
                dmg = other.explosionDamage*(1-(distance_to_object(other)/other.blastRadius));
                if id == other.ownerPlayer.object// self damage resistance
                    dmg *= 5/9;
                damageAuto(other.ownerPlayer, id, dmg);
                timeUnscathed = 0;
                if (lastDamageDealer != other.ownerPlayer and lastDamageDealer != player)
                {
                    secondToLastDamageDealer = lastDamageDealer;
                    alarm[4] = alarm[3]
                }
                if (other.ownerPlayer != id)
                    alarm[3] = ASSIST_TIME;
                lastDamageDealer = other.ownerPlayer;
                lastDamageSource = GENERATOR_EXPLOSION;
                
                if(global.gibLevel > 0)
                {
                    repeat(3)
                    {
                        var blood;
                        blood = instance_create(x,y,Blood);
                        blood.direction = point_direction(other.x,other.y,x,y)-180;
                    }
                }
                if (id==other.ownerPlayer.object)
                    moveStatus = 1;
                else if (other.team == team)
                    moveStatus = 2;
                else
                    moveStatus = 4;
            }
            cloakAlpha = max(cloakAlpha, 0.3);
            cloakFlicker = true;
            alarm[7] = 3;
        }
    }

    
    with (Sentry)
    {
        if (distance_to_object(other) < other.blastRadius) and (team != other.team)
        { 
            if (1 - distance_to_object(other)/other.blastRadius <= 0.25 and other.splashThreshhold)
                continue;
            hp -= other.explosionDamage*(1-(distance_to_object(other)/other.blastRadius));
            lastDamageDealer = other.ownerPlayer;
            lastDamageSource = GENERATOR_EXPLOSION;
        }   
    }    
     
     with (Generator)
     {
        if( (distance_to_object(other) < other.blastRadius) and (team != other.team) )
        { 
            if (1 - distance_to_object(other)/other.blastRadius <= 0.25 and other.splashThreshhold)
                continue;
            alarm[0] = regenerationBuffer;
            isShieldRegenerating = false;
            //allow overkill to be applied directly to the target
            var hitDamage;
            hitDamage = other.explosionDamage*(1-(distance_to_object(other)/other.blastRadius));
            if (hitDamage > shieldHp) {
                hp -= hitDamage - shieldHp;
                hp -= shieldHp * shieldResistance;
                shieldHp = 0;
            } else {
                hp -= hitDamage * shieldResistance;
                shieldHp -= hitDamage;
            }
        }   
    }
       
    with (Rocket)
    {
        if (distance_to_object(other) < other.affectRadius * 0.75
            and (other.team != team or other.ownerPlayer == ownerPlayer))
        {
            if(distance_to_object(other) < other.affectRadius * 0.25)
            {
                characterHit = -1;
                event_user(5);
            }
            else
            {
                motion_add(point_direction(other.x,other.y,x,y),10-10*(distance_to_object(other)/(other.affectRadius)));
            }
        }
    }
    
    with (DeadGuy)
    {
        if (distance_to_object(other) < other.affectRadius * 0.75)
        {
            motion_add(point_direction(other.x,other.y,x,y),10-10*(distance_to_object(other)/other.affectRadius));
        }
    }
    
    with(Mine) {
        if (distance_to_object(other) < other.blastRadius
            and (other.team != team or other.ownerPlayer == ownerPlayer))
        {
            if (1 - distance_to_object(other)/other.blastRadius <= 0.25 and other.splashThreshhold)
                continue;
            event_user(2);
        }
    }
    with (Gib)
    {
        if (distance_to_object(other) < other.affectRadius * 0.75)
        {
            motion_add(point_direction(other.x,other.y,x,y),15-15*(distance_to_object(other)/other.affectRadius));
            rotspeed=random(151)-75;
        }
    }
    
    with(LooseSheet)
    {
        if (distance_to_object(other) < other.affectRadius * 0.75)
            motion_add(point_direction(other.x, other.y, x, y)
                      ,10-10*(distance_to_object(other)/other.affectRadius));
        
    }
    
    // Handle bubbles
    
    with(Bubble)
    {
        if (point_distance(x, y, other.x, other.y) < other.blastRadius + selfPopRadius)
            instance_destroy();
    }
    
    instance_destroy();
');

object_event_add(GNdemoPipe, ev_step, ev_step_begin, '      
    if (global.particles == PARTICLES_NORMAL && index > 1) {
        effect_create_above(ef_smokeup, x, y, 0, c_gray);
        index = 0;
    }
    index += 0.3 * global.delta_factor;
    
    if(!variable_local_exists("firststep")) firststep = true;
    
    vspeed += 0.4 * global.delta_factor;
    image_angle = direction;
    
    if(!firststep && global.delta_factor != 1) {
        x += hspeed * global.delta_factor;
        y += vspeed * global.delta_factor;
        x -= hspeed;
        y -= vspeed;
    } else {
        firststep = false;
    }
    
    gunSetSolids();
    if (!place_free(x, y)) {
        speed = 0;
    }
    gunUnsetSolids();
');

object_event_add(GNdemoPipe, ev_collision, Character, ' 
    if (!other.ubered && other.player.team != team) {
        event_user(2);
    }
');
    
object_event_add(GNdemoPipe, ev_draw, 0, '
    draw_sprite_ext(GNdemoPipeS, ownerPlayer.team, x, y, 1, 1, image_angle, c_white, 1);
');